--DROP PROCEDURE App.NVCC_usp_GetAnnouncement

USE NWIC_PanelMgmt
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE App.NVCC_usp_GetAnnouncement
	-- @active is a numeric parameter. If 1, only return the active announcements;
	-- if 0, return all announcements.
	@active int
AS
--==================================================================================
--Requestor             : Non Va Coordinated Care Project
--Author                : Brian Diggs
--Object/SP Name        : NVCC_usp_GetLogs
--Server                : DNS.URL        
--Data Base             : NWIC_PanelMgmt
--Schema                : app
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 06-06-2016
--
--
--Last Changed          : 
--Last Changed By		: 
--Reason For Change		: 
--
--Purpose               : To get selected announcements
--==================================================================================
--Uses: NWIC_PanelMgmt.App.NVCC_Announcement
--Uses: NWIC_PanelMgmt.App.NVCC_DimAnnouncement

BEGIN
	IF (@active = 0) 
		BEGIN
			SELECT
				A.AnnouncementID,
				DA.AnnouncementType,
				S.StaffName AS Creator,
				A.CreationDT,
				A.ExpirationDT,
				A.Text
			FROM NVCC_Announcement AS A
				INNER JOIN NVCC_DimAnnouncement AS DA
					ON A.AnnouncementTypeID = DA.AnnouncementTypeID
				LEFT JOIN NWIC_PanelMgmt.App.NVCC_Users u
					ON A.Creator = u.DomainPlusNetworkUserName
				LEFT JOIN CDWWork.SStaff.SStaff s
					ON u.UserIEN = s.StaffIEN and u.Sta3n = s.Sta3n
		END
	ELSE IF (@active = 1)
		BEGIN
			SELECT
				A.AnnouncementID,
				DA.AnnouncementType,
				S.StaffName AS Creator,
				A.CreationDT,
				A.ExpirationDT,
				A.Text
			FROM NVCC_Announcement AS A
				INNER JOIN NVCC_DimAnnouncement AS DA
					ON A.AnnouncementTypeID = DA.AnnouncementTypeID
				LEFT JOIN NWIC_PanelMgmt.App.NVCC_Users u
					ON A.Creator = u.DomainPlusNetworkUserName
				LEFT JOIN CDWWork.SStaff.SStaff s
					ON u.UserIEN = s.StaffIEN and u.Sta3n = s.Sta3n
			WHERE
				ExpirationDT >= GETUTCDATE()
		END
END
GO

exec sp_SignAppObject 'NVCC_usp_GetAnnouncement';
